/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.logistics.item.guide.brewing;

import com.farmersrespite.core.utility.FRTextUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.content.logistics.item.guide.brewing.BrewingGuideMenu;

public class BrewingGuideScreen
extends AbstractSimiContainerScreen<BrewingGuideMenu> {
    private static final ResourceLocation TEXTURE = CentralKitchen.genRL("textures/gui/brewing_guide.png");
    private static final int WINDOW_WIDTH = 144;
    private static final int BACKGROUND_WIDTH = 152;
    private static final int BACKGROUND_HEIGHT = 80;
    private static final int ICON_SIZE = 48;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public BrewingGuideScreen(BrewingGuideMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void m_7856_() {
        this.setWindowSize(152, 84 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-56, 0);
        super.m_7856_();
        int guideX = this.getLeftOfCentered(144);
        int guideY = this.f_97736_;
        this.extraAreas = ImmutableList.of((Object)new Rect2i(guideX + 144 + 16, guideY + 16, 48, 48), (Object)new Rect2i(guideX, guideY, this.f_97726_, this.f_97727_));
    }

    protected void m_7286_(@NotNull PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + 80 + 4;
        this.renderPlayerInventory(pose, invX, invY);
        int guideX = this.getLeftOfCentered(144);
        int guideY = this.f_97736_;
        this.renderGuide(pose, guideX, guideY);
        BrewingGuideScreen.m_93215_((PoseStack)pose, (Font)this.f_96547_, (Component)this.f_96539_, (int)(guideX + 72), (int)(guideY + 5), (int)0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((ItemStack)((BrewingGuideMenu)this.f_97732_).contentHolder)).at((float)(guideX + 144 + 16), (float)(guideY + 16), -200.0f)).scale(3.0).render(pose);
    }

    private void renderGuide(@NotNull PoseStack pose, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, x, y, 0, 0, 152, 80);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        boolean needWater = ((BrewingGuideMenu)this.m_6262_()).needWater();
        int status = ((BrewingGuideMenu)this.m_6262_()).getBlazeStatus();
        if (level == null || status <= 0) {
            this.m_93228_(pose, x + 56, y + 24, 0, 80, 24, 24);
        } else {
            int time = (int)level.m_46467_() / 5 % 3 + 1;
            this.m_93228_(pose, x + 56, y + 24, 24 * time, 80, 24, 24);
        }
        if (needWater) {
            this.m_93228_(pose, x + 11, y + 32, 176, 80, 5, 32);
        }
        this.m_93228_(pose, x + 48, y + 66, 96, 80 + status * 6, 80, 6);
    }

    protected void m_7025_(@NotNull PoseStack pose, int x, int y) {
        if (((BrewingGuideMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            if (this.f_97734_.f_40219_ == 2) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                ItemStack mealStack = this.f_97734_.m_7993_();
                tooltip.add(((MutableComponent)mealStack.m_41720_().m_41466_()).m_130938_(mealStack.m_41791_().getStyleModifier()));
                ItemStack containerStack = ((BrewingGuideMenu)this.f_97732_).getContainerItem();
                String container = !containerStack.m_41619_() ? containerStack.m_41720_().m_41466_().getString() : "";
                tooltip.add(FRTextUtils.getTranslation((String)"container.kettle.served_on", (Object[])new Object[]{container}).m_130940_(ChatFormatting.GRAY));
                this.m_96597_(pose, tooltip, x, y);
            } else {
                this.m_6057_(pose, this.f_97734_.m_7993_(), x, y);
            }
        }
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

